package com.qboxus.tictic.services


import android.app.NotificationChannel
import android.app.NotificationManager
import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.core.app.NotificationCompat
import androidx.work.CoroutineWorker
import androidx.work.ForegroundInfo
import androidx.work.WorkerParameters
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.HomeFragment
import com.qboxus.tictic.apiclasses.FileUploader
import com.qboxus.tictic.models.UploadVideoModel
import com.qboxus.tictic.simpleclasses.DataHolder
import com.qboxus.tictic.simpleclasses.FirebaseFunction
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import com.volley.plus.interfaces.Callback
import kotlinx.coroutines.suspendCancellableCoroutine
import org.json.JSONObject
import java.io.File
import kotlin.coroutines.resume

class   VideoUploadWorker(appContext: Context, workerParams: WorkerParameters) : CoroutineWorker(appContext, workerParams) {


    override suspend fun doWork(): Result {

        val bundle=DataHolder.instance?.data

        val videopath = bundle?.getString("uri") ?: return Result.failure()
        val draftFile = bundle?.getString("draft_file")
        val uploadModel = bundle?.getParcelable<UploadVideoModel>("data") ?: return Result.failure()


        DataHolder.instance?.data=null


        return try {
            val result = suspendCancellableCoroutine<Result> { continuation ->

                val defaultBase64=Functions.getSharedPreference(applicationContext).getString(Variables.default_video_thumb,"")
                val selectedThumb=Functions.getSharedPreference(applicationContext).getString(Variables.selected_video_thumb,"")

                FirebaseFunction.uploadVideoThumbFirebase(applicationContext,defaultBase64!!,object :Callback{
                    override fun onResponce(url: String?) {
                        if(url!=null && url.contains(Variables.http)) {
                            uploadModel.default_thumbnail=url

                            if(Functions.isStringHasValue(selectedThumb)){

                                FirebaseFunction.uploadVideoThumbFirebase(applicationContext,selectedThumb!!,object :Callback{
                                    override fun onResponce(url2: String?) {

                                            uploadModel.user_thumbnail= url2!!

                                            val fileUploader =
                                                FileUploader(File(videopath), applicationContext, uploadModel)
                                            fileUploader.SetCallBack(object :
                                                FileUploader.FileUploaderCallback {
                                                override fun onError() {
                                                    Functions.printLog(Constants.tag, "Error")
                                                    continuation.resume(Result.failure())
                                                    sendBroadByName(Variables.homeBroadCastAction)
                                                    sendBroadByName(Variables.profileBroadCastAction)
                                                }

                                                override fun onFinish(responses: String) {
                                                    Functions.printLog(Constants.tag, responses)
                                                    try {
                                                        val jsonObject = JSONObject(responses)
                                                        if (jsonObject.optInt("code", 0) == 200) {
                                                            Variables.reloadMyVideos = true
                                                            Variables.reloadMyVideosInner = true
                                                            deleteDraftFile(draftFile)
                                                            Functions.showToast(
                                                                applicationContext,
                                                                applicationContext.getString(R.string.your_video_is_uploaded_successfully)
                                                            )
                                                        }
                                                        continuation.resume(Result.success())
                                                        sendBroadByName(Variables.homeBroadCastAction)
                                                        sendBroadByName(Variables.profileBroadCastAction)
                                                    } catch (e: Exception) {
                                                        Functions.printLog(Constants.tag, "Exception: $e")
                                                        continuation.resume(Result.failure())
                                                        sendBroadByName(Variables.homeBroadCastAction)
                                                        sendBroadByName(Variables.profileBroadCastAction)
                                                    }
                                                }

                                                override fun onProgressUpdate(
                                                    currentpercent: Int,
                                                    totalpercent: Int,
                                                    msg: String
                                                ) {
                                                    if (currentpercent > 0) {
                                                        val bundle = Bundle().apply {
                                                            putBoolean("isShow", true)
                                                            putInt("currentpercent", currentpercent)
                                                            putInt("totalpercent", totalpercent)
                                                        }
                                                        HomeFragment.uploadingCallback?.onResponce(bundle)
                                                    }
                                                }
                                            })

                                    }
                                })

                            }

                            else {

                                val fileUploader =
                                    FileUploader(File(videopath), applicationContext, uploadModel)
                                fileUploader.SetCallBack(object :
                                    FileUploader.FileUploaderCallback {
                                    override fun onError() {
                                        Functions.printLog(Constants.tag, "Error")
                                        continuation.resume(Result.failure())
                                        sendBroadByName(Variables.homeBroadCastAction)
                                        sendBroadByName(Variables.profileBroadCastAction)
                                    }

                                    override fun onFinish(responses: String) {
                                        Functions.printLog(Constants.tag, responses)
                                        try {
                                            val jsonObject = JSONObject(responses)
                                            if (jsonObject.optInt("code", 0) == 200) {
                                                Variables.reloadMyVideos = true
                                                Variables.reloadMyVideosInner = true
                                                deleteDraftFile(draftFile)
                                                Functions.showToast(
                                                    applicationContext,
                                                    applicationContext.getString(R.string.your_video_is_uploaded_successfully)
                                                )
                                            }
                                            continuation.resume(Result.success())
                                            sendBroadByName(Variables.homeBroadCastAction)
                                            sendBroadByName(Variables.profileBroadCastAction)
                                        } catch (e: Exception) {
                                            Functions.printLog(Constants.tag, "Exception: $e")
                                            continuation.resume(Result.failure())
                                            sendBroadByName(Variables.homeBroadCastAction)
                                            sendBroadByName(Variables.profileBroadCastAction)
                                        }
                                    }

                                    override fun onProgressUpdate(
                                        currentpercent: Int,
                                        totalpercent: Int,
                                        msg: String
                                    ) {
                                        if (currentpercent > 0) {
                                            val bundle = Bundle().apply {
                                                putBoolean("isShow", true)
                                                putInt("currentpercent", currentpercent)
                                                putInt("totalpercent", totalpercent)
                                            }
                                            HomeFragment.uploadingCallback?.onResponce(bundle)
                                        }
                                    }
                                })
                            }
                        }
                        else{

                            continuation.resume(Result.failure())
                        }
                    }
                })

            }
            result
        }
        catch (e: Exception) {
            Functions.printLog(Constants.tag, "Exception: $e")
            Result.failure()
        }

    }


    private fun sendBroadByName(action: String) {
        val intent = Intent(action)
        intent.setPackage(applicationContext.packageName)
        applicationContext.sendBroadcast(intent)
    }

    private fun deleteDraftFile(draftFile: String?) {
        draftFile?.let {
            val file = File(it)
            if (file.exists()) {
                file.delete()
            }
        }
    }

    private fun createForegroundInfo(): ForegroundInfo {
        val channelId = "Upload_Channel"
        val title = applicationContext.getString(R.string.uploading_video)

        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            val channel = NotificationChannel(channelId, title, NotificationManager.IMPORTANCE_LOW)
            val manager = applicationContext.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            manager.createNotificationChannel(channel)
        }

        val notification = NotificationCompat.Builder(applicationContext, channelId)
            .setContentTitle(title)
            .setTicker(title)
            .setContentText(applicationContext.getString(R.string.please_wait_video_is_uploading))
            .setSmallIcon(android.R.drawable.stat_sys_upload)
            .setOngoing(true)
            .build()

        return ForegroundInfo(1, notification)
    }

}